<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Notification extends Model 
{

    protected $table = 'notifications';
    public $timestamps = true;
    protected $fillable = array('order_id', 'title', 'client_id', 'family_id', 'driver_id', 'type');

    public function clientNotification()
    {
        return $this->belongsTo('App\User', 'client_id');
    }

    public function familyNotification()
    {
        return $this->belongsTo('App\User', 'family_id');
    }

    public function driveNotification()
    {
        return $this->belongsTo('App\User', 'driver_id');
    }

    public function order()
    {
        return $this->belongsTo('App\Models\Order', 'order_id');
    }

}